package game;

import java.awt.Point;


public class IntRect {
	
	private int minX;
	private int maxX;
	private int minY;
	private int maxY;
	
	public IntRect(int x, int y, int width, int height) {
		minX = x;
		minY = y;
		maxX = width + x;
		maxY = height + y;
	}

	public int getMinX() {
		return minX;
	}

	public int getMaxX() {
		return maxX;
	}

	public int getMinY() {
		return minY;
	}

	public int getMaxY() {
		return maxY;
	}
	
	
	public boolean intersects(IntRect other) {
		
		if(this.minX > other.maxX)
			return false;
		if(this.maxX < other.minX)
			return false;
		if(this.minY > other.maxY)
			return false;
		if(this.maxY < other.minY)
			return false;
		
		
		return true;
		
		
	}
	
	public boolean contains(IntRect other) {
		
		if(other.minX < this.minX)
			return false;
		if(other.minY < this.minY)
			return false;
		if(other.maxX > this.maxX)
			return false;
		if(other.maxY > this.maxY)
			return false;
		
		return true;
		
	}
	
	public Point getCenter() {
		
		return new Point((minX + maxX) / 2 , (minY + maxY) / 2);
		
	}
	
	
	public int width() {
		return maxX - minX;
	}
	
	public int height() {
		return maxY - minY;
	}
	
	
	public boolean contains(Point p) {
		return p.y < maxY && p.y > minY && p.x < maxX && p.x > minX;
	}
	
	public boolean containsIncludeBorder(Point p) {
		return p.y <= maxY && p.y >= minY && p.x <= maxX && p.x >= minX;
	}
	
	public void move(int xMove, int yMove) {
		minX += xMove;
		maxX += xMove;
		
		minY += yMove;
		maxY += yMove;
	}
	
	public void resetDimensions(int newMinX, int newMinY, int newWidth, int newHeight) {
		minX = newMinX;
		minY = newMinY;
		maxX = newMinX + newWidth;
		maxY = newMinY + newHeight;
	}
	
	public IntRect clone() {
		
		IntRect returnValue = new IntRect(minX, minY, this.width(), this.height());
		return returnValue;
		
	}
	
}
